#!/bin/sh
#TMP_VER_FILE="global.template"
TMP_VER_FILE=$1
TAG_VER_FILE="global.js"
SWP_VER_FILE=".global"
PATH_VER_XML=$2"/build/product/config.xml"
echo "*****************Create global.js Begain***********************************"
HARD_VERSION=`pwd | LANG=C grep "HardwareVersion" $PATH_VER_XML | cut -d '>' -f 2 | cut -d '<' -f 1`
SOFT_VERSION=`pwd | LANG=C grep "SoftwareVersion" $PATH_VER_XML | cut -d '>' -f 2 | cut -d '<' -f 1`
echo 'Hardware version: '$HARD_VERSION
echo 'Software version: '$SOFT_VERSION
echo 'TMP_VER_FILE:'$TMP_VER_FILE
echo 'TAG_VER_FILE:'$TAG_VER_FILE
cp -f $TMP_VER_FILE $TAG_VER_FILE
touch $SWP_VER_FILE
cat $TAG_VER_FILE | sed -e "s/(%_SOFTWARE_%)/`echo $SOFT_VERSION`/g" >$SWP_VER_FILE
cat $SWP_VER_FILE | sed -e "s/(%_HARDWARE_%)/`echo $HARD_VERSION`/g" >$TAG_VER_FILE
iconv -f GB2312 -t UTF-8 $TAG_VER_FILE > $SWP_VER_FILE
mv -f $SWP_VER_FILE $TAG_VER_FILE
rm -f $SWP_VER_FILE
echo "*****************Create global.js successful!******************************"

